/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Ostrich
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();
    public int jumps = 0;
    private int toggledup = 0;

    public Ostrich(World w) {
        super(w);
        this.maxrenderdist = 128;
        this.height = 2.75f;
        this.width = 0.85f;
        this.uniquename = "DangerZone:Ostrich";
        this.moveSpeed = 0.45f;
        this.setMaxHealth(35.0f);
        this.setHealth(35.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 45;
        this.setExperience(34);
        this.swimoffset = -1.25f;
        this.setCanDespawn(false);
        this.takesFallDamage = false;
        this.setOnGround(true);
        this.takesFallDamage = false;
        this.enable_followfood = true;
        this.foodsearchDistance = 16;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 20.0f;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    @Override
    public boolean isBuddy(Entity e) {
        return e instanceof Ostrich;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && ic == null && (this.getOwnerName() == null || this.getOwnerName() != null && p.myname.equals(this.getOwnerName()))) {
            if (this.isMountedBy(p)) {
                this.unMount(p);
            } else {
                this.Mount(p);
                this.setSitting(false);
                this.setStaying(false);
            }
            return false;
        }
        return super.rightClickedByPlayer(p, ic);
    }

    @Override
    public float getRiderYoffset() {
        if (this.isBaby()) {
            return 0.3375f;
        }
        return 1.35f;
    }

    @Override
    public float getRiderXZoffset() {
        if (this.isBaby()) {
            return -0.0625f;
        }
        return -0.25f;
    }

    @Override
    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        Entity rider = this.getRiderEntity();
        if (rider == null) {
            this.jumpstrength = 0.15f * this.height;
            super.doEntityAction(deltaT);
            return;
        }
        if (!(rider instanceof Player)) {
            this.jumpstrength = 0.15f * this.height;
            super.doEntityAction(deltaT);
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        this.jumpstrength = 1.5f * this.height;
        if (!rider.getUp()) {
            this.toggledup = 0;
        }
        if (this.getOnGround()) {
            this.jumps = 0;
            this.toggledup = 0;
            if (rider.getUp()) {
                this.toggledup = 1;
                rider.jump(this.jumpstrength);
            }
        } else if (rider.getUp() && this.jumps < 3 && this.toggledup == 0) {
            this.toggledup = 1;
            ++this.jumps;
            rider.motiony += 0.75f + this.jumpstrength;
            if (rider instanceof Player && this.world.isServer) {
                Player p = (Player)rider;
                p.server_thread.sendVelocityUpdateToPlayer(p.motionx, p.motiony, p.motionz);
            }
        }
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.corn.itemID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:cryo_hurt";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:cryo_death";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyostrich.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.ostrichmeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        int i = 1 + this.world.rand.nextInt(4);
        int j = 0;
        while (j < i) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
            ++j;
        }
        if (this.world.rand.nextInt(1000) == 42) {
            j = 0;
            while (j < 1000) {
                Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.5f, this.dimension, this.posx, this.posy, this.posz);
                ++j;
            }
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(15000) == 1) {
            Utils.doDropRand(this.world, 0, Items.eggostrich.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Ostrichtexture.png");
        }
        return this.texture;
    }
}

